{% set my_host = salt['grains.get']("nodename") %}

{% if salt['pillar.get']('aldpro-hosts:' + my_host) is defined %}
{% if salt['pillar.get']('aldpro-hosts:' + my_host +':custom_ldap_flyterm') is defined %}

{% set color = salt['pillar.get']('aldpro-hosts:' + my_host +':custom_ldap_flyterm:flyterm_color') %}
{% set font = salt['pillar.get']('aldpro-hosts:' + my_host +':custom_ldap_flyterm:flyterm_font') %}
{% set size = salt['pillar.get']('aldpro-hosts:' + my_host +':custom_ldap_flyterm:flyterm_font_size') %}

{% if color != '' %}
copy_file_to_etc:
  file.managed:
    - name: /etc/xdg/rusbitech/fly-term.conf
    - source: salt://files/fly-term.conf
    - replace: True

fly-term_configuration:
  cmd.run:
    - name: |
      sed -i 's/^color_scheme=.*$/color_scheme={{ color }}/' /etc/xdg/rusbitech/fly-term.conf
      sed -i 's/^font=.*$/font=\"{{ font }},{{ size }},-1,5,50,0,0,0,0,0\"/' /etc/xdg/rusbitech/fly-term.conf
      sed -i 's/^custom_font=.*$/custom_font=\"{{ font }},{{ size }},-1,5,50,0,0,0,0,0\"/' /etc/xdg/rusbitech/fly-term.conf

{% endif %}

{% endif %}
{% endif %}
