#!/bin/bash
# Настройка и ввод в домен клиента ALD Pro
# Дата: 22.06.2023

# Ввод значений переменных
echo -n "Имя хоста: "
read host_name
echo -n "Имя домена [ald.test]: "
read domain_name
domain_name=${domain_name:=ald.test}

echo -n "IP-адрес/префикс: " 
read ip_address
echo -n "DNS-сервер: "
read dns_server
echo -n "Шлюз: "
read gate

echo -n "Пароль для admin [P@ssw0rd]: "
read pass
pass=${pass:=P@ssw0rd}

#echo $host_name $domain_name $ip_address $dns_server $gate $pass

# Изменение файла /etc/hosts
export host_line="${ip_address%/*} $host_name.$domain_name $host_name"
#sudo sed -i "s/^127\.0\.1\.1.*$/$host_line/" /etc/hosts
sudo sed -i "/^127\.0\.0\.1/a$host_line" /etc/hosts

# Изменение имени хоста
export host_name domain_name
sudo hostnamectl set-hostname $host_name.$domain_name

# Создание файла с сетевысми настройками для интерфейса eth0
cat << EOF > eth0
auto eth0
iface eth0 inet static
        address $ip_address
        gateway $gate
EOF

sudo cp eth0 /etc/network/interfaces.d/eth0
rm eth0

# Создание файла /etc/resolv.conf
cat << EOF > resolv.conf
search $domain_name
nameserver $dns_server
EOF

sudo cp resolv.conf /etc/resolv.conf
rm resolv.conf

# Отключение NetworkManager
sudo systemctl stop NetworkManager
sudo systemctl disable NetworkManager
sudo systemctl mask NetworkManager

# Настройка сетевого интерфейса согласно параметром из файла /etc/network/interfaces.d/eth0
sudo systemctl restart networking

# Установка клиента ALDPro
ping -c3 dl.astralinux.ru &> /dev/null
if [ $? -ne 0 ]
        then
               echo "Ошибка доступа к репозиториям"
               exit 1          
fi

sudo apt update
sudo DEBIAN_FRONTEND=noninteractive apt install -q -y aldpro-client

# Ввод хоста в домен ALD Pro
sudo /opt/rbta/aldpro/client/bin/aldpro-client-installer -c $domain_name -u admin -p "$pass"  -d $host_name -i -f
