#!/bin/bash
cat << END > /etc/network/interfaces.d/router
auto eth1
iface eth1 inet static
 address 192.168.100.1/24

auto eth2
iface eth2 inet static
 address 10.11.0.1/24

auto eth0
iface eth0 inet dhcp

END

systemctl restart networkinig.service

cat << END > /etc/apt/sources.list
deb http://download.astralinux.ru/astra/frozen/1.7_x86-64/1.7.3/repository-main/ 1.7_x86-64 main contrib non-free
deb http://download.astralinux.ru/astra/frozen/1.7_x86-64/1.7.3/repository-update/ 1.7_x86-64 main contrib non-free
deb http://download.astralinux.ru/astra/frozen/1.7_x86-64/1.7.3/repository-base/ 1.7_x86-64 main contrib non-free
deb http://download.astralinux.ru/astra/frozen/1.7_x86-64/1.7.3/repository-extended/ 1.7_x86-64 main contrib non-free
END

apt update 
apt -y install dnsmasq iptables

cat << END > /etc/sysctl.d/ip_forward.conf
net.ipv4.ip_forward=1
END

sysctl -p /etc/sysctl.d/ip_forward.conf

iptables -t nat  -I POSTROUTING -o eth0 -j MASQUERADE

mkdir /etc/iptables
iptables-save >/etc/iptables/rules.v4

cat << END > /etc/network/if-pre-up.d/iptables
#!/bin/sh
if test -r /etc/iptables/rules.v4
then
	iptables-restore < /etc/iptables/rules.v4
fi
exit 0
END

chmod +x /etc/network/if-pre-up.d/iptables

