﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace OverloadingAnOperator
{
    class EmployeeDatabase
    {
        Employee[] employees;
        int topOfArray;

        public EmployeeDatabase()
        {
            employees = new Employee[1000];
            topOfArray = 0;
        }

        public void AddToDatabase(Employee employee)
        {
            employees[topOfArray] = employee;
            topOfArray++;
        }

        public Employee this[string Name]
        {
            get
            {
                foreach (Employee employee in employees)
                {
                    if (employee.Name.Equals(Name))
                    {
                        return employee;
                    }
                }
                return null;
            }
        }

        public static EmployeeDatabase operator +(EmployeeDatabase database, Employee employee)
        {
            database.AddToDatabase(employee);
            return database;
        }
    }
}
