﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;
using System.Windows.Forms;

namespace FileSystemApplication
{
    class Program
    {
        [STAThread]
        static void Main(string[] args)
        {
            //------------------------------------------
            // Reading and Writing from Files.
            //------------------------------------------

            string filePath = @"C:\Users\Student\Documents\MyTextFile.txt";
            string fileContents;

            #region Writing examples

            string[] fileLines = { "Line 1", "Line 2", "Line 3" };
            File.AppendAllLines(filePath, fileLines);

            fileContents = "I am writing this text to a file called MyTextFile.txt";
            File.AppendAllText(filePath, fileContents);

            byte[] fileBytes = { 12, 134, 12, 8, 32 };
            File.WriteAllBytes(filePath, fileBytes);

            File.WriteAllLines(filePath, fileLines);

            File.WriteAllText(filePath, fileContents);

            #endregion

            #region Reading examples

            byte[] data = File.ReadAllBytes(filePath);

            string[] lines = File.ReadAllLines(filePath);

            string data2 = File.ReadAllText(filePath);


            #endregion

            //------------------------------------------
            // Manipulating Directories.
            //------------------------------------------

            string dirPath = @"C:\Users\Student\Documents\";

            #region Directory class members

            Directory.CreateDirectory(dirPath);
            //Directory.Delete(dirPath); // You may want to change the path before demonstrating Delete()
            string[] dirs = Directory.GetDirectories(dirPath);
            string[] files = Directory.GetFiles(dirPath);

            #endregion

            #region DirectoryInfo class members

            DirectoryInfo dir = new DirectoryInfo(dirPath);
            bool exists = dir.Exists;
            DirectoryInfo[] dirs2 = dir.GetDirectories();
            FileInfo[] files2 = dir.GetFiles();
            string fullName = dir.FullName;


            #endregion

            #region Enumerating directory contents

            dirPath = @"C:\Users\Student\Documents";

            // Get all sub directories in the Documents directory.
            string[] subDirs = Directory.GetDirectories(dirPath);

            foreach (string dir3 in subDirs)
            {
                // Display the directory name.
                Console.WriteLine("{0} contains the following files:", dir3);

                // Get all the files in each directory.
                files = Directory.GetFiles(dir3);

                foreach (string file in files)
                {
                    // Display the file name.
                    Console.WriteLine(file);
                }
            }

            #endregion

            //------------------------------------------
            // Using the Common File System Dialog Boxes
            //------------------------------------------

            #region Open and Save dialog examples

            OpenFileDialog openDlg = new OpenFileDialog();

            SaveFileDialog saveDlg = new SaveFileDialog();


            openDlg.Title = "Browse for a file to open";
            openDlg.Multiselect = false;
            openDlg.InitialDirectory = @"C:\Users\Student\Documents";
            openDlg.Filter = "Word (*.doc) |*.doc;";

            saveDlg.Title = "Browse for a save location";
            saveDlg.DefaultExt = "doc";
            saveDlg.AddExtension = true;
            saveDlg.InitialDirectory = @"C:\Users\Student\Documents";
            saveDlg.OverwritePrompt = true;

            openDlg.ShowDialog();

            saveDlg.ShowDialog();

            string selectedFileName = openDlg.FileName;

            string selectedFileName2 = saveDlg.FileName;


            #endregion

            //------------------------------------------
            // Reading and Writing Binary data
            //------------------------------------------

            #region Writing

            string destinationFilePath = @"C:\Users\Student\Documents\BinaryDataFile.bin";

            // Collection of bytes.
            byte[] dataCollection = { 1, 4, 6, 7, 12, 33, 26, 98, 82, 101 };

            // Create a FileStream object so that you can interact with the file 
            // system.
            FileStream destFile = new FileStream(
                destinationFilePath, // Pass in the destination path.
                FileMode.Create,     // Always create new file.
                FileAccess.Write);   // Only perform writing.

            // Create a BinaryWriter object passing in the FileStream object.
            BinaryWriter writer = new BinaryWriter(destFile);

            // Write each byte to stream.
            foreach (byte dataItem in dataCollection)
            {
                writer.Write(dataItem);
            }

            // Close both streams to flush the data to the file.
            writer.Close();
            destFile.Close();

            #endregion

            #region Reading

            // Source file path.
            string sourceFilePath =
                @"C:\Users\Student\Documents\BinaryDataFile.bin";

            // Create a FileStream object so that you can interact with the file 
            // system.
            FileStream sourceFile = new FileStream(
                sourceFilePath,  // Pass in the source file path.
                FileMode.Open,   // Open an existing file.
                FileAccess.Read);// Read an existing file.

            // Create a BinaryWriter object passing in the FileStream object.
            BinaryReader reader = new BinaryReader(sourceFile);

            // Store the current position of the stream.
            int position = 0;
            // Store the length of the stream.
            int length = (int)reader.BaseStream.Length;

            // Create an array to store each byte from the file.
            byte[] dataCollection2 = new byte[length];
            int returnedByte;
            while ((returnedByte = reader.Read()) != -1)
            {
                // Set the value at the next index.
                dataCollection2[position] = (byte)returnedByte;

                // Advance our position variable.
                position += sizeof(byte);
            }

            // Close the streams to release any file handles.
            reader.Close();
            sourceFile.Close();


            #endregion

            //------------------------------------------
            // Reading and Writing BText
            //------------------------------------------

            #region Writing

            destinationFilePath =
                @"C:\Users\Student\Documents\TextDataFile.txt";

            string data4 = "Hello, this will be written in plain text";

            // Create a FileStream object so that you can interact with the file 
            // system.
            FileStream destFile1 = new FileStream(
                destinationFilePath, // Pass in the destination path.
                FileMode.Create,     // Always create new file.
                FileAccess.Write);   // Only perform writing.

            // Create a new StreamWriter object.
            StreamWriter writer1 = new StreamWriter(destFile1);

            // Write the string to the file.
            writer1.WriteLine(data4);

            // Always close the underlying streams to flush the data to the file 
            // and release any file handles.
            writer1.Close();
            destFile1.Close();


            #endregion

            #region Reading

            sourceFilePath =
                @"C:\Users\Student\Documents\TextDataFile.txt";

            // Create a FileStream object so that you can interact with the file 
            // system.
            FileStream sourceFile3 = new FileStream(
                sourceFilePath,  // Pass in the source file path.
                FileMode.Open,   // Open an existing file.
                FileAccess.Read);// Read an existing file.

            StreamReader reader3 = new StreamReader(sourceFile3);
            StringBuilder fileContents3 = new StringBuilder();

            // Check to see if the end of the file
            // has been reached.
            while (reader3.Peek() != -1)
            {
                // Read the next character.
                fileContents3.Append((char)reader3.Read());
            }

            // Store the file contents in a new string variable.
            string data5 = fileContents3.ToString();

            // Always close the underlying streams release any file handles.
            reader.Close();
            sourceFile3.Close();


            #endregion
        }
    }
}
