﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace UsingInheritanceDemo
{
    class Television
    {
        protected virtual void SetCurrentChannel()
        {
            Console.WriteLine("Channel set.");
        }

        protected void TurnOn()
        {
            Console.WriteLine("Television on.");
        }
    }

    class WidescreenTV : Television
    {
        protected override void SetCurrentChannel()
        {
            Console.WriteLine("Widescreen channel set.");
        }

        public WidescreenTV()
            : base()
        {
            TurnOn();
            SetCurrentChannel();
            base.SetCurrentChannel();
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            WidescreenTV tv = new WidescreenTV();
            Console.ReadLine();
        }
    }
}
